/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.irc.pircbotx.event;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.creeperhost.minetogether.lib.chat.irc.pircbotx.event.SubscribeEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Listener;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventSubscriberListener
implements Listener {
    private static final Logger logger = LogManager.getLogger();
    private static final Class<?>[] EMPTY = new Class[0];
    private final Map<Class<?>, Class<?>[]> eventHierarchyCache = new HashMap();
    private final Map<Class<?>, List<Handler>> eventHandlers = new HashMap();

    @Override
    public void onEvent(Event event) {
        this.fireEvent(event.getClass(), event);
    }

    private void fireEvent(Class<?> clazz, Event event) {
        this.fireFor(clazz, event);
        for (Class<?> parent : this.getHierarchy(clazz)) {
            this.fireEvent(parent, event);
        }
    }

    private void fireFor(Class<?> clazz, Event event) {
        List<Handler> handlers = this.eventHandlers.get(clazz);
        if (handlers == null) {
            return;
        }
        for (Handler handler : handlers) {
            try {
                handler.handle.invoke(handler.instance, event);
            }
            catch (Throwable throwable) {
                logger.error("Failed to invoke event handler.", throwable);
            }
        }
    }

    public void addListener(Object instance) {
        Class<?> listenerClass = instance.getClass();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            for (Method method : listenerClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(SubscribeEvent.class)) continue;
                Class<?>[] args = method.getParameterTypes();
                if (args.length != 1) {
                    logger.error("Method '{}.{}' does not have a singular parameter, Ignoring..", (Object)listenerClass.getName(), (Object)method.getName());
                    continue;
                }
                Class<?> argument = args[0];
                if (!GenericEvent.class.isAssignableFrom(argument)) {
                    logger.error("Method '{}.{}' first argument is not assignable from GenericEvent, Got '{}', ignoring..", (Object)listenerClass.getName(), (Object)method.getName(), (Object)argument.getName());
                    continue;
                }
                method.setAccessible(true);
                MethodHandle handle = lookup.unreflect(method);
                this.eventHandlers.computeIfAbsent(argument, e -> new LinkedList()).add(new Handler(instance, handle));
            }
        }
        catch (Throwable e2) {
            logger.error("Failed to register listener.", e2);
        }
    }

    private Class<?>[] getHierarchy(Class<?> clazz) {
        if (clazz == GenericEvent.class) {
            return EMPTY;
        }
        Class<?>[] hierarchy = this.eventHierarchyCache.get(clazz);
        if (hierarchy == null) {
            Class<?> superClass = clazz.getSuperclass();
            Class<?>[] interfaces = clazz.getInterfaces();
            if (superClass == null) {
                hierarchy = interfaces;
            } else {
                hierarchy = Arrays.copyOf(interfaces, interfaces.length + 1);
                hierarchy[0] = superClass;
                System.arraycopy(interfaces, 0, hierarchy, 1, interfaces.length);
            }
            this.eventHierarchyCache.put(clazz, hierarchy);
        }
        return hierarchy;
    }

    private static final class Handler {
        private final Object instance;
        private final MethodHandle handle;

        private Handler(Object instance, MethodHandle handle) {
            this.instance = instance;
            this.handle = handle;
        }
    }
}

